/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.kafka.clients.admin.NewTopic;

public class KafkaTopicFactory {
    @NotEmpty
    @JsonProperty
    private String name;
    @Min(value=1L)
    @JsonProperty
    private @Min(value=1L) int partitions;
    @Min(value=1L)
    @JsonProperty
    private @Min(value=1L) short replicationFactor;
    @NotNull
    @JsonProperty
    private Map<String, String> configs = Collections.emptyMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public short getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(short replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, String> configs) {
        this.configs = configs;
    }

    public NewTopic asNewTopic() {
        return new NewTopic(this.name, this.partitions, this.replicationFactor).configs(this.configs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTopicFactory that = (KafkaTopicFactory)o;
        return this.partitions == that.partitions && this.replicationFactor == that.replicationFactor && this.name.equals(that.name) && Objects.equals(this.configs, that.configs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.partitions, this.replicationFactor, this.configs);
    }
}

