/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka.deserializer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.kafka.deserializer.DeserializerFactory;
import io.dropwizard.validation.ValidationMethod;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.UUIDDeserializer;

@JsonTypeName(value="uuid")
public class UUIDDeserializerFactory
extends DeserializerFactory {
    @NotNull
    @JsonProperty
    private String encoding = "UTF8";

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @JsonIgnore
    @ValidationMethod(message="Invalid charset used for UUIDDeserializerFactory")
    public boolean isEncodingValid() {
        return Charset.isSupported(this.encoding);
    }

    @Override
    public Class<? extends Deserializer<?>> getDeserializerClass() {
        return UUIDDeserializer.class;
    }

    @Override
    public Map<String, Object> build(boolean isKey) {
        String encodingPropertyName;
        String propertyName;
        if (isKey) {
            propertyName = "key.deserializer";
            encodingPropertyName = "key.deserializer.encoding";
        } else {
            propertyName = "value.deserializer";
            encodingPropertyName = "value.deserializer.encoding";
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put(propertyName, this.getDeserializerClass());
        config.put(encodingPropertyName, this.encoding);
        return Collections.unmodifiableMap(config);
    }
}

