/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka.health;

import com.codahale.metrics.health.HealthCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterResult;

public class KafkaAdminHealthCheck
extends HealthCheck {
    private final AdminClient adminClient;
    private final String name;

    public KafkaAdminHealthCheck(AdminClient adminClient, String name) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.name = Objects.requireNonNull(name);
    }

    protected HealthCheck.Result check() throws Exception {
        try {
            DescribeClusterResult response = this.adminClient.describeCluster();
            boolean nodesNotEmpty = !((Collection)response.nodes().get()).isEmpty();
            boolean clusterIdAvailable = response.clusterId() != null;
            boolean aControllerExists = response.controller().get() != null;
            ArrayList<String> errors = new ArrayList<String>();
            if (!nodesNotEmpty) {
                errors.add("no nodes found for " + this.name);
            }
            if (!clusterIdAvailable) {
                errors.add("no cluster id available for " + this.name);
            }
            if (!aControllerExists) {
                errors.add("no active controller exists for " + this.name);
            }
            if (!errors.isEmpty()) {
                String errorMessage = String.join((CharSequence)",", errors);
                return HealthCheck.Result.unhealthy((String)errorMessage);
            }
            return HealthCheck.Result.healthy();
        }
        catch (Exception e) {
            return HealthCheck.Result.unhealthy((String)"Error describing Kafka Cluster name={}", (Object[])new Object[]{this.name, e});
        }
    }
}

