/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka.health;

import com.codahale.metrics.health.HealthCheck;
import java.util.Collection;
import java.util.Objects;
import org.apache.kafka.clients.producer.Producer;

public class KafkaProducerHealthCheck
extends HealthCheck {
    private final Producer producer;
    private final Collection<String> topics;

    public KafkaProducerHealthCheck(Producer producer, Collection<String> topics) {
        this.producer = Objects.requireNonNull(producer);
        this.topics = Objects.requireNonNull(topics);
    }

    protected HealthCheck.Result check() {
        try {
            this.topics.forEach(arg_0 -> ((Producer)this.producer).partitionsFor(arg_0));
            return HealthCheck.Result.healthy();
        }
        catch (Exception e) {
            return HealthCheck.Result.unhealthy((Throwable)e);
        }
    }
}

