/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka.managed;

import io.dropwizard.lifecycle.Managed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAdminClientManager
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdminClientManager.class);
    private final AdminClient adminClient;
    private final String name;
    private final Collection<NewTopic> topics;

    public KafkaAdminClientManager(AdminClient adminClient, String name, Collection<NewTopic> topics) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.name = Objects.requireNonNull(name);
        this.topics = topics;
    }

    public void start() throws Exception {
        log.info("Starting adminClient for name={}", (Object)this.name);
        if (!this.topics.isEmpty()) {
            log.trace("Searching existing topics in cluster.");
            Set existingTopics = (Set)this.adminClient.listTopics().names().get();
            ArrayList matchingTopics = new ArrayList();
            for (String t : existingTopics) {
                this.topics.removeIf(newTopic -> {
                    boolean match = newTopic.name().equals(t);
                    if (match) {
                        matchingTopics.add(t);
                    }
                    return match;
                });
            }
            if (!matchingTopics.isEmpty()) {
                log.info("Not attempting to re-create existing topics {}.", matchingTopics);
            }
            this.adminClient.createTopics(this.topics);
        }
    }

    public void stop() throws Exception {
        log.info("Shutting down adminClient for name={}", (Object)this.name);
        this.adminClient.close();
    }
}

