/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardMetricsReporter
implements MetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(DropwizardMetricsReporter.class);
    public static final String SHOULD_INCLUDE_TAGS_CONFIG = "io.dropwizard.kafka.metrics.includeTags";
    public static final String METRICS_NAME_CONFIG = "io.dropwizard.kafka.metrics.name";
    private final MetricRegistry registry;
    private boolean includeTags = false;
    private String name;

    public DropwizardMetricsReporter() {
        this.registry = SharedMetricRegistries.getOrCreate((String)"default");
    }

    public DropwizardMetricsReporter(MetricRegistry registry) {
        this.registry = registry;
    }

    public void init(List<KafkaMetric> metrics) {
        if (this.includeTags) {
            metrics.stream().filter(metric -> this.shouldRegister((Gauge<Object>)((Gauge)() -> ((KafkaMetric)metric).metricValue()))).forEach(metric -> this.createMetricNamesWithTags(metric.metricName()).forEach(metricName -> this.tryRegister((String)metricName, (Gauge<Object>)((Gauge)() -> ((KafkaMetric)metric).metricValue()))));
        } else {
            metrics.stream().filter(metric -> this.shouldRegister((Gauge<Object>)((Gauge)() -> ((KafkaMetric)metric).metricValue()))).forEach(metric -> this.tryRegister(this.createMetricName(metric.metricName()), (Gauge<Object>)((Gauge)() -> ((KafkaMetric)metric).metricValue())));
        }
    }

    String createMetricName(MetricName metricName) {
        return MetricRegistry.name((String)this.name, (String[])new String[]{metricName.group(), metricName.name()});
    }

    List<String> createMetricNamesWithTags(MetricName metricName) {
        if (metricName.tags().isEmpty()) {
            return ImmutableList.of((Object)this.createMetricName(metricName));
        }
        return metricName.tags().entrySet().stream().map(entry -> MetricRegistry.name((String)this.name, (String[])new String[]{metricName.group(), metricName.name(), (String)entry.getKey(), (String)entry.getValue()})).collect(Collectors.toList());
    }

    public void metricChange(KafkaMetric metric) {
        Gauge metricToRegister = () -> ((KafkaMetric)metric).metricValue();
        if (!this.shouldRegister((Gauge<Object>)metricToRegister)) {
            return;
        }
        if (this.includeTags) {
            List<String> metricNames = this.createMetricNamesWithTags(metric.metricName());
            metricNames.forEach(metricName -> {
                this.registry.remove(metricName);
                this.tryRegister((String)metricName, (Gauge<Object>)metricToRegister);
            });
        } else {
            String metricName2 = this.createMetricName(metric.metricName());
            this.registry.remove(metricName2);
            this.tryRegister(metricName2, (Gauge<Object>)metricToRegister);
        }
    }

    public void metricRemoval(KafkaMetric metric) {
        if (this.includeTags) {
            this.createMetricNamesWithTags(metric.metricName()).forEach(arg_0 -> ((MetricRegistry)this.registry).remove(arg_0));
        } else {
            this.registry.remove(this.createMetricName(metric.metricName()));
        }
    }

    public void close() {
        this.registry.getGauges((metricName, metric) -> metricName.startsWith(this.name)).forEach((metricName, metric) -> this.registry.remove(metricName));
    }

    public void configure(Map<String, ?> configs) {
        this.includeTags = Optional.ofNullable(configs.get(SHOULD_INCLUDE_TAGS_CONFIG)).filter(String.class::isInstance).map(String.class::cast).map(Boolean::parseBoolean).orElse(false);
        this.name = Objects.requireNonNull((String)configs.get(METRICS_NAME_CONFIG), "Metrics name required to configure DropwizardMetricsReporter");
    }

    boolean isIncludeTags() {
        return this.includeTags;
    }

    protected boolean shouldRegister(Gauge<Object> gauge) {
        return gauge.getValue() instanceof Number;
    }

    private void tryRegister(String metricName, Gauge<Object> metricToRegister) {
        try {
            this.registry.register(metricName, metricToRegister);
        }
        catch (IllegalArgumentException e) {
            log.debug("Failed to register metric={}, as it is already registered", (Object)metricName);
        }
    }
}

