/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka.security;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.kafka.security.SecurityFactory;
import java.util.Map;
import javax.validation.constraints.NotEmpty;

@JsonTypeName(value="sasl_plaintext")
public class SaslPlaintextSecurityFactory
extends SecurityFactory {
    @NotEmpty
    @JsonProperty
    private String saslMechanism = "PLAIN";
    @JsonProperty
    private String saslJaas;

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public String getSaslJaas() {
        return this.saslJaas;
    }

    public void setSaslJaas(String saslJaas) {
        this.saslJaas = saslJaas;
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"security.protocol", (Object)this.securityProtocol.toUpperCase()).put((Object)"sasl.mechanism", (Object)this.saslMechanism).put((Object)"ssl.endpoint.identification.algorithm", (Object)this.sslEndpointIdentificationAlgorithm);
        if (this.saslJaas != null) {
            builder.put((Object)"sasl.jaas.config", (Object)this.saslJaas);
        }
        return builder.build();
    }
}

