/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.kafka.serializer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.kafka.serializer.SerializerFactory;
import io.dropwizard.validation.ValidationMethod;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.UUIDSerializer;

@JsonTypeName(value="uuid")
public class UUIDSerializerFactory
extends SerializerFactory {
    @NotNull
    @JsonProperty
    private String encoding = "UTF8";

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @JsonIgnore
    @ValidationMethod(message="Invalid charset used for UUIDSerializerFactory")
    public boolean isEncodingValid() {
        return Charset.isSupported(this.encoding);
    }

    @Override
    public Class<? extends Serializer<?>> getSerializerClass() {
        return UUIDSerializer.class;
    }

    @Override
    public Map<String, Object> build(boolean isKey) {
        String encodingPropertyName;
        String propertyName;
        if (isKey) {
            propertyName = "key.serializer";
            encodingPropertyName = "key.serializer.encoding";
        } else {
            propertyName = "value.serializer";
            encodingPropertyName = "value.serializer.encoding";
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put(propertyName, this.getSerializerClass());
        config.put(encodingPropertyName, this.encoding);
        return Collections.unmodifiableMap(config);
    }
}

