/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/x-protobuf"})
@Produces(value={"application/x-protobuf", "application/x-protobuf-text-format"})
public class ProtocolBufferMessageBodyProvider
implements MessageBodyReader<Message>,
MessageBodyWriter<Message> {
    private final Map<Class<Message>, Method> methodCache = new ConcurrentHashMap<Class<Message>, Method>();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Message.class.isAssignableFrom(type);
    }

    public Message readFrom(Class<Message> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            Method newBuilder = this.methodCache.computeIfAbsent(type, t -> {
                try {
                    return t.getMethod("newBuilder", new Class[0]);
                }
                catch (Exception e) {
                    return null;
                }
            });
            Message.Builder builder = (Message.Builder)newBuilder.invoke(type, new Object[0]);
            return builder.mergeFrom(entityStream).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public long getSize(Message m, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (mediaType.getSubtype().contains("text-format")) {
            String formatted = TextFormat.printToUnicodeString((MessageOrBuilder)m);
            return formatted.getBytes(StandardCharsets.UTF_8).length;
        }
        return m.getSerializedSize();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Message.class.isAssignableFrom(type);
    }

    public void writeTo(Message m, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (mediaType.getSubtype().contains("text-format")) {
            entityStream.write(m.toString().getBytes(StandardCharsets.UTF_8));
        } else {
            m.writeTo(entityStream);
        }
    }
}

