/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.protobuf;

import com.google.common.base.Converter;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class Converters {
    public static final Converter<Timestamp, Instant> toInstantUTC = Converter.from(t -> Instant.ofEpochSecond(t.getSeconds(), t.getNanos()), i -> Timestamp.newBuilder().setSeconds(i.getEpochSecond()).setNanos(i.getNano()).build());
    public static final Converter<Timestamp, OffsetDateTime> toOffsetDateTimeUTC = Converter.from(t -> ((Instant)toInstantUTC.convert(t)).atOffset(ZoneOffset.UTC), o -> (Timestamp)toInstantUTC.reverse().convert((Object)o.toInstant()));
    public static final Converter<Timestamp, ZonedDateTime> toZonedDateTimeUTC = Converter.from(t -> ((OffsetDateTime)toOffsetDateTimeUTC.convert(t)).toZonedDateTime(), z -> (Timestamp)toOffsetDateTimeUTC.reverse().convert((Object)z.toOffsetDateTime()));
    public static final Converter<Duration, java.time.Duration> toDuration = Converter.from(d -> java.time.Duration.ofSeconds(d.getSeconds(), d.getNanos()), d -> Duration.newBuilder().setSeconds(d.getSeconds()).setNanos(d.getNano()).build());
}

