/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import io.dropwizard.jersey.protobuf.ProtocolBufferMediaType;
import io.dropwizard.jersey.protobuf.protos.DropwizardProtos;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class InvalidProtocolBufferExceptionMapper
implements ExceptionMapper<InvalidProtocolBufferException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvalidProtocolBufferExceptionMapper.class);

    public Response toResponse(InvalidProtocolBufferException exception) {
        DropwizardProtos.ErrorMessage message = DropwizardProtos.ErrorMessage.newBuilder().setMessage("Unable to process protocol buffer").setCode(Response.Status.BAD_REQUEST.getStatusCode()).build();
        LOGGER.debug("Unable to process protocol buffer message", (Throwable)exception);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(ProtocolBufferMediaType.APPLICATION_PROTOBUF_TYPE).entity((Object)message).build();
    }
}

