/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis;

import brave.Tracing;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import io.dropwizard.jackson.Discoverable;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.redis.clientresources.ClientResourcesFactory;
import io.dropwizard.redis.clientresources.DefaultClientResourcesFactory;
import io.dropwizard.redis.codec.RedisCodecFactory;
import io.dropwizard.redis.metrics.event.visitor.ClusterTopologyChangedEventVisitor;
import io.dropwizard.redis.metrics.event.visitor.CommandLatencyEventVisitor;
import io.dropwizard.redis.metrics.event.visitor.ConnectedEventVisitor;
import io.dropwizard.redis.metrics.event.visitor.ConnectionActivatedEventVisitor;
import io.dropwizard.redis.metrics.event.visitor.ConnectionDeactivatedEventVisitor;
import io.dropwizard.redis.metrics.event.visitor.DisconnectedEventVisitor;
import io.dropwizard.redis.metrics.event.visitor.EventVisitor;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class AbstractRedisClientFactory<K, V>
implements Discoverable {
    @NotNull
    @JsonProperty
    protected String name;
    @Valid
    @JsonProperty
    protected ClusterTopologyRefreshOptions clusterTopologyRefreshOptions;
    @Valid
    @NotNull
    @JsonProperty
    protected ClientResourcesFactory clientResources = new DefaultClientResourcesFactory();
    @Valid
    @NotNull
    @JsonProperty
    protected RedisCodecFactory<K, V> redisCodec;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterTopologyRefreshOptions getClusterTopologyRefreshOptions() {
        return this.clusterTopologyRefreshOptions;
    }

    public void setClusterTopologyRefreshOptions(ClusterTopologyRefreshOptions clusterTopologyRefreshOptions) {
        this.clusterTopologyRefreshOptions = clusterTopologyRefreshOptions;
    }

    public ClientResourcesFactory getClientResources() {
        return this.clientResources;
    }

    public void setClientResources(ClientResourcesFactory clientResources) {
        this.clientResources = clientResources;
    }

    public RedisCodecFactory<K, V> getRedisCodec() {
        return this.redisCodec;
    }

    public void setRedisCodec(RedisCodecFactory<K, V> redisCodec) {
        this.redisCodec = redisCodec;
    }

    public StatefulConnection<K, V> build(HealthCheckRegistry healthChecks, LifecycleEnvironment lifecycle, MetricRegistry metrics) {
        return this.build(healthChecks, lifecycle, metrics, null);
    }

    public abstract StatefulConnection<K, V> build(HealthCheckRegistry var1, LifecycleEnvironment var2, MetricRegistry var3, @Nullable Tracing var4);

    protected List<EventVisitor> buildEventVisitors(MetricRegistry metrics) {
        return ImmutableList.of((Object)new ClusterTopologyChangedEventVisitor(this.name, metrics), (Object)new CommandLatencyEventVisitor(this.name, metrics), (Object)new ConnectedEventVisitor(this.name, metrics), (Object)new ConnectionActivatedEventVisitor(this.name, metrics), (Object)new ConnectionDeactivatedEventVisitor(this.name, metrics), (Object)new DisconnectedEventVisitor(this.name, metrics));
    }
}

