/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis;

import brave.Tracing;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.redis.RedisClientFactory;
import io.lettuce.core.api.StatefulRedisConnection;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RedisClientBundle<K, V, T extends Configuration>
implements ConfiguredBundle<T> {
    private @Nullable StatefulRedisConnection<K, V> connection;

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        RedisClientFactory<K, V> redisClientFactory = Objects.requireNonNull(this.getRedisClientFactory(configuration));
        Tracing tracing = Tracing.current();
        this.connection = redisClientFactory.build(environment.healthChecks(), environment.lifecycle(), environment.metrics(), tracing);
    }

    public abstract RedisClientFactory<K, V> getRedisClientFactory(T var1);

    public StatefulRedisConnection<K, V> getConnection() {
        return Objects.requireNonNull(this.connection);
    }
}

