/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis;

import brave.Tracing;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.redis.AbstractRedisClientFactory;
import io.dropwizard.redis.clientoptions.ClientOptionsFactory;
import io.dropwizard.redis.health.RedisHealthCheck;
import io.dropwizard.redis.managed.RedisClientManager;
import io.dropwizard.redis.metrics.event.LettuceMetricsSubscriber;
import io.dropwizard.redis.uri.RedisURIFactory;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.resource.ClientResources;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.function.Consumer;

@JsonTypeName(value="basic")
public class RedisClientFactory<K, V>
extends AbstractRedisClientFactory<K, V> {
    @Valid
    @NotNull
    @JsonProperty
    private RedisURIFactory node;
    @Valid
    @NotNull
    @JsonProperty
    private ClientOptionsFactory clientOptions = new ClientOptionsFactory();

    @Override
    public StatefulRedisConnection<K, V> build(HealthCheckRegistry healthChecks, LifecycleEnvironment lifecycle, MetricRegistry metrics) {
        return this.build(healthChecks, lifecycle, metrics, null);
    }

    @Override
    public StatefulRedisConnection<K, V> build(HealthCheckRegistry healthChecks, LifecycleEnvironment lifecycle, MetricRegistry metrics, Tracing tracing) {
        RedisURI uri = this.node.build();
        ClientResources resources = this.clientResources.build(this.name, metrics, tracing);
        RedisClient redisClient = RedisClient.create((ClientResources)resources, (RedisURI)uri);
        redisClient.setOptions(this.clientOptions.build());
        RedisCodec codec = this.redisCodec.build();
        StatefulRedisConnection connection = redisClient.connect(codec);
        lifecycle.manage(new RedisClientManager((AbstractRedisClient)redisClient, connection, this.name));
        healthChecks.register(this.name, (HealthCheck)new RedisHealthCheck(() -> connection.sync().ping()));
        redisClient.getResources().eventBus().get().subscribe((Consumer)new LettuceMetricsSubscriber(this.buildEventVisitors(metrics)));
        return connection;
    }
}

