/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis;

import brave.Tracing;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.redis.RedisClusterClientFactory;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RedisClusterClientBundle<K, V, T extends Configuration>
implements ConfiguredBundle<T> {
    private @Nullable StatefulRedisClusterConnection<K, V> clusterConnection;

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        RedisClusterClientFactory<K, V> redisClusterClientFactory = Objects.requireNonNull(this.getRedisClusterClientFactory(configuration));
        Tracing tracing = Tracing.current();
        this.clusterConnection = redisClusterClientFactory.build(environment.healthChecks(), environment.lifecycle(), environment.metrics(), tracing);
    }

    public abstract RedisClusterClientFactory<K, V> getRedisClusterClientFactory(T var1);

    public StatefulRedisClusterConnection<K, V> getClusterConnection() {
        return Objects.requireNonNull(this.clusterConnection);
    }
}

