/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis;

import brave.Tracing;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.redis.AbstractRedisClientFactory;
import io.dropwizard.redis.clientoptions.ClusterClientOptionsFactory;
import io.dropwizard.redis.health.RedisHealthCheck;
import io.dropwizard.redis.managed.RedisClientManager;
import io.dropwizard.redis.metrics.event.LettuceMetricsSubscriber;
import io.dropwizard.redis.metrics.event.visitor.EventVisitor;
import io.dropwizard.redis.uri.RedisURIFactory;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.resource.ClientResources;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.validator.constraints.NotEmpty;

@JsonTypeName(value="cluster")
public class RedisClusterClientFactory<K, V>
extends AbstractRedisClientFactory<K, V> {
    @Valid
    @NotEmpty
    @JsonProperty
    private List<RedisURIFactory> nodes = Collections.emptyList();
    @Valid
    @NotNull
    @JsonProperty
    private ClusterClientOptionsFactory clientOptions = new ClusterClientOptionsFactory();

    public ClusterClientOptionsFactory getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClusterClientOptionsFactory clientOptions) {
        this.clientOptions = clientOptions;
    }

    @Override
    public StatefulRedisClusterConnection<K, V> build(HealthCheckRegistry healthChecks, LifecycleEnvironment lifecycle, MetricRegistry metrics) {
        return this.build(healthChecks, lifecycle, metrics, null);
    }

    @Override
    public StatefulRedisClusterConnection<K, V> build(HealthCheckRegistry healthChecks, LifecycleEnvironment lifecycle, MetricRegistry metrics, @Nullable Tracing tracing) {
        List uris = this.nodes.stream().map(RedisURIFactory::build).collect(Collectors.toList());
        ClientResources resources = this.clientResources.build(this.name, metrics, tracing);
        RedisClusterClient redisClusterClient = RedisClusterClient.create((ClientResources)resources, uris);
        redisClusterClient.setOptions(this.clientOptions.build());
        RedisCodec codec = this.redisCodec.build();
        StatefulRedisClusterConnection connection = redisClusterClient.connect(codec);
        lifecycle.manage(new RedisClientManager((AbstractRedisClient)redisClusterClient, connection, this.name));
        healthChecks.register(this.name, (HealthCheck)new RedisHealthCheck(() -> connection.sync().ping()));
        List<EventVisitor> eventVisitors = this.buildEventVisitors(metrics);
        redisClusterClient.getResources().eventBus().get().subscribe((Consumer)new LettuceMetricsSubscriber(this.buildEventVisitors(metrics)));
        return connection;
    }
}

