/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.clientoptions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.redis.socket.SocketOptionsFactory;
import io.dropwizard.redis.ssl.SslOptionsFactory;
import io.dropwizard.redis.timeout.TimeoutOptionsFactory;
import io.lettuce.core.ClientOptions;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

public class ClientOptionsFactory {
    @JsonProperty
    protected boolean pingBeforeActivateConnection = true;
    @JsonProperty
    protected boolean cancelCommandsOnReconnectFailure = false;
    @JsonProperty
    protected boolean publishOnScheduler = false;
    @JsonProperty
    protected boolean autoReconnect = true;
    @JsonProperty
    protected boolean suspendReconnectOnProtocolFailure = false;
    @Min(value=0L)
    @JsonProperty
    protected @Min(value=0L) int requestQueueSize = Integer.MAX_VALUE;
    @NotNull
    @JsonProperty
    protected ClientOptions.DisconnectedBehavior disconnectedBehavior = ClientOptions.DEFAULT_DISCONNECTED_BEHAVIOR;
    @Valid
    @NotNull
    @JsonProperty
    protected SocketOptionsFactory socketOptions = new SocketOptionsFactory();
    @Valid
    @JsonProperty
    protected SslOptionsFactory sslOptions;
    @Valid
    @NotNull
    @JsonProperty
    protected TimeoutOptionsFactory timeoutOptions = new TimeoutOptionsFactory();

    public boolean isPingBeforeActivateConnection() {
        return this.pingBeforeActivateConnection;
    }

    public void setPingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
        this.pingBeforeActivateConnection = pingBeforeActivateConnection;
    }

    public boolean isCancelCommandsOnReconnectFailure() {
        return this.cancelCommandsOnReconnectFailure;
    }

    public void setCancelCommandsOnReconnectFailure(boolean cancelCommandsOnReconnectFailure) {
        this.cancelCommandsOnReconnectFailure = cancelCommandsOnReconnectFailure;
    }

    public boolean isPublishOnScheduler() {
        return this.publishOnScheduler;
    }

    public void setPublishOnScheduler(boolean publishOnScheduler) {
        this.publishOnScheduler = publishOnScheduler;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public boolean isSuspendReconnectOnProtocolFailure() {
        return this.suspendReconnectOnProtocolFailure;
    }

    public void setSuspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
        this.suspendReconnectOnProtocolFailure = suspendReconnectOnProtocolFailure;
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public void setRequestQueueSize(int requestQueueSize) {
        this.requestQueueSize = requestQueueSize;
    }

    public ClientOptions.DisconnectedBehavior getDisconnectedBehavior() {
        return this.disconnectedBehavior;
    }

    public void setDisconnectedBehavior(ClientOptions.DisconnectedBehavior disconnectedBehavior) {
        this.disconnectedBehavior = disconnectedBehavior;
    }

    public SocketOptionsFactory getSocketOptions() {
        return this.socketOptions;
    }

    public void setSocketOptions(SocketOptionsFactory socketOptions) {
        this.socketOptions = socketOptions;
    }

    public SslOptionsFactory getSslOptions() {
        return this.sslOptions;
    }

    public void setSslOptions(SslOptionsFactory sslOptions) {
        this.sslOptions = sslOptions;
    }

    public TimeoutOptionsFactory getTimeoutOptions() {
        return this.timeoutOptions;
    }

    public void setTimeoutOptions(TimeoutOptionsFactory timeoutOptions) {
        this.timeoutOptions = timeoutOptions;
    }

    public ClientOptions build() {
        ClientOptions.Builder builder = ClientOptions.builder();
        return this.addBuildParams(builder).build();
    }

    protected ClientOptions.Builder addBuildParams(ClientOptions.Builder builder) {
        builder.pingBeforeActivateConnection(this.pingBeforeActivateConnection).cancelCommandsOnReconnectFailure(this.cancelCommandsOnReconnectFailure).publishOnScheduler(this.publishOnScheduler).autoReconnect(this.autoReconnect).suspendReconnectOnProtocolFailure(this.suspendReconnectOnProtocolFailure).requestQueueSize(this.requestQueueSize).disconnectedBehavior(this.disconnectedBehavior).socketOptions(this.socketOptions.build()).timeoutOptions(this.timeoutOptions.build());
        if (this.sslOptions != null && this.sslOptions.isEnabled()) {
            builder.sslOptions(this.sslOptions.build());
        }
        return builder;
    }
}

