/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.clientoptions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.redis.clientoptions.ClientOptionsFactory;
import io.dropwizard.redis.topology.ClusterTopologyRefreshOptionsFactory;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;

public class ClusterClientOptionsFactory
extends ClientOptionsFactory {
    @JsonProperty
    private boolean validateClusterNodeMembership = true;
    @Min(value=0L)
    @JsonProperty
    private @Min(value=0L) int maxRedirects = 5;
    @Valid
    @JsonProperty
    private ClusterTopologyRefreshOptionsFactory topologyRefreshOptions;

    public boolean isValidateClusterNodeMembership() {
        return this.validateClusterNodeMembership;
    }

    public void setValidateClusterNodeMembership(boolean validateClusterNodeMembership) {
        this.validateClusterNodeMembership = validateClusterNodeMembership;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public ClusterTopologyRefreshOptionsFactory getTopologyRefreshOptions() {
        return this.topologyRefreshOptions;
    }

    public void setTopologyRefreshOptions(ClusterTopologyRefreshOptionsFactory topologyRefreshOptions) {
        this.topologyRefreshOptions = topologyRefreshOptions;
    }

    public ClusterClientOptions build() {
        ClusterClientOptions.Builder builder = ((ClusterClientOptions.Builder)super.addBuildParams((ClientOptions.Builder)ClusterClientOptions.builder())).validateClusterNodeMembership(this.validateClusterNodeMembership).maxRedirects(this.maxRedirects);
        if (this.topologyRefreshOptions != null) {
            ClusterTopologyRefreshOptions clusterTopologyRefreshOptions = this.topologyRefreshOptions.build();
            builder.topologyRefreshOptions(clusterTopologyRefreshOptions);
        }
        return builder.build();
    }
}

