/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.clientresources;

import brave.Tracing;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dropwizard.jackson.Discoverable;
import io.dropwizard.redis.delay.DelayFactory;
import io.dropwizard.redis.delay.ExponentialDelayFactory;
import io.dropwizard.redis.event.DefaultEventBusFactory;
import io.dropwizard.redis.event.DefaultEventLoopGroupProviderFactory;
import io.dropwizard.redis.event.EventBusFactory;
import io.dropwizard.redis.event.EventLoopGroupProviderFactory;
import io.dropwizard.redis.metrics.CommandLatencyRecorderFactory;
import io.dropwizard.redis.metrics.DefaultCommandLatencyCollectorFactory;
import io.dropwizard.redis.metrics.DefaultEventPublisherOptionsFactory;
import io.dropwizard.redis.metrics.EventPublisherOptionsFactory;
import io.dropwizard.redis.netty.DefaultEventExecutorGroupFactory;
import io.dropwizard.redis.netty.EventExecutorGroupFactory;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class ClientResourcesFactory
implements Discoverable {
    @Valid
    @NotNull
    @JsonProperty
    protected CommandLatencyRecorderFactory commandLatencyRecorder = new DefaultCommandLatencyCollectorFactory();
    @Valid
    @NotNull
    @JsonProperty
    protected EventPublisherOptionsFactory eventPublisherOptions = new DefaultEventPublisherOptionsFactory();
    @Valid
    @NotNull
    @JsonProperty
    protected EventBusFactory eventBusFactory = new DefaultEventBusFactory();
    @Valid
    @NotNull
    @JsonProperty
    protected EventExecutorGroupFactory eventExecutorGroup = new DefaultEventExecutorGroupFactory();
    @Valid
    @NotNull
    @JsonProperty
    protected EventLoopGroupProviderFactory eventLoopGroupProvider = new DefaultEventLoopGroupProviderFactory();
    @Min(value=1L)
    @JsonProperty
    protected @Min(value=1L) int computationThreads = DefaultClientResources.DEFAULT_COMPUTATION_THREADS;
    @Min(value=1L)
    @JsonProperty
    protected @Min(value=1L) int ioThreads = DefaultClientResources.DEFAULT_IO_THREADS;
    @Valid
    @NotNull
    protected DelayFactory delay = new ExponentialDelayFactory();

    public CommandLatencyRecorderFactory getCommandLatencyRecorder() {
        return this.commandLatencyRecorder;
    }

    public void setCommandLatencyRecorder(CommandLatencyRecorderFactory commandLatencyRecorder) {
        this.commandLatencyRecorder = commandLatencyRecorder;
    }

    public EventPublisherOptionsFactory getEventPublisherOptions() {
        return this.eventPublisherOptions;
    }

    public void setEventPublisherOptions(EventPublisherOptionsFactory eventPublisherOptions) {
        this.eventPublisherOptions = eventPublisherOptions;
    }

    public EventBusFactory getEventBusFactory() {
        return this.eventBusFactory;
    }

    public void setEventBusFactory(EventBusFactory eventBusFactory) {
        this.eventBusFactory = eventBusFactory;
    }

    public EventExecutorGroupFactory getEventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    public void setEventExecutorGroup(EventExecutorGroupFactory eventExecutorGroup) {
        this.eventExecutorGroup = eventExecutorGroup;
    }

    public EventLoopGroupProviderFactory getEventLoopGroupProvider() {
        return this.eventLoopGroupProvider;
    }

    public void setEventLoopGroupProvider(EventLoopGroupProviderFactory eventLoopGroupProvider) {
        this.eventLoopGroupProvider = eventLoopGroupProvider;
    }

    public int getComputationThreads() {
        return this.computationThreads;
    }

    public void setComputationThreads(int computationThreads) {
        this.computationThreads = computationThreads;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public DelayFactory getDelay() {
        return this.delay;
    }

    public void setDelay(DelayFactory delay) {
        this.delay = delay;
    }

    public abstract ClientResources build(String var1, MetricRegistry var2, @Nullable Tracing var3);
}

