/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.clientresources;

import brave.Tracing;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.redis.clientresources.ClientResourcesFactory;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import io.lettuce.core.tracing.BraveTracing;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;
import reactor.core.scheduler.Schedulers;

@JsonTypeName(value="default")
public class DefaultClientResourcesFactory
extends ClientResourcesFactory {
    @Override
    public ClientResources build(String name, MetricRegistry metrics, @Nullable Tracing tracing) {
        EventExecutorGroup executorGroup = this.eventExecutorGroup.build(this.computationThreads, name, metrics);
        DefaultClientResources.Builder builder = DefaultClientResources.builder().commandLatencyRecorder(this.commandLatencyRecorder.build(metrics)).commandLatencyPublisherOptions(this.eventPublisherOptions.build()).eventExecutorGroup(executorGroup).eventBus(this.eventBusFactory.build(Schedulers.fromExecutor((Executor)executorGroup))).computationThreadPoolSize(this.computationThreads).ioThreadPoolSize(this.ioThreads).eventLoopGroupProvider(this.eventLoopGroupProvider.build(this.computationThreads)).reconnectDelay(this.delay.build());
        if (tracing != null) {
            builder.tracing((io.lettuce.core.tracing.Tracing)BraveTracing.create((Tracing)tracing));
        }
        return builder.build();
    }
}

