/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.codec;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.redis.codec.RedisCodecFactory;
import io.lettuce.core.codec.CompressionCodec;
import io.lettuce.core.codec.RedisCodec;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;

@JsonTypeName(value="compression")
public class CompressionCodecFactory<K, V>
implements RedisCodecFactory<K, V> {
    @Valid
    @NotNull
    @JsonProperty
    private RedisCodecFactory<K, V> delegatee;
    @NotNull
    @JsonProperty
    private CompressionCodec.CompressionType compressionType;

    public RedisCodecFactory<K, V> getDelegatee() {
        return this.delegatee;
    }

    public void setDelegatee(RedisCodecFactory<K, V> delegatee) {
        this.delegatee = delegatee;
    }

    public CompressionCodec.CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionCodec.CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    @Override
    public RedisCodec<K, V> build() {
        return CompressionCodec.valueCompressor(this.delegatee.build(), (CompressionCodec.CompressionType)this.compressionType);
    }
}

