/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.delay;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.redis.delay.DelayFactory;
import io.dropwizard.util.Duration;
import io.lettuce.core.resource.Delay;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@JsonTypeName(value="equal-jitter")
public class EqualJitterDelayFactory
implements DelayFactory {
    @NotNull
    @JsonProperty
    private Duration lowerBound = Duration.seconds((long)0L);
    @NotNull
    @JsonProperty
    private Duration upperBound = Duration.seconds((long)30L);
    @Min(value=0L)
    @JsonProperty
    private @Min(value=0L) long base = 0L;

    public Duration getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Duration lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Duration getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Duration upperBound) {
        this.upperBound = upperBound;
    }

    public long getBase() {
        return this.base;
    }

    public void setBase(long base) {
        this.base = base;
    }

    @Override
    public Supplier<Delay> build() {
        return () -> Delay.equalJitter((long)this.lowerBound.toMilliseconds(), (long)this.upperBound.toMilliseconds(), (long)this.base, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

