/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.delay;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.redis.delay.DelayFactory;
import io.dropwizard.util.Duration;
import io.lettuce.core.resource.Delay;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@JsonTypeName(value="exponential")
public class ExponentialDelayFactory
implements DelayFactory {
    @NotNull
    @JsonProperty
    private Duration lowerBound = Duration.seconds((long)0L);
    @NotNull
    @JsonProperty
    private Duration upperBound = Duration.seconds((long)30L);
    @Min(value=2L)
    @JsonProperty
    private @Min(value=2L) int powersOf = 2;

    public Duration getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Duration lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Duration getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Duration upperBound) {
        this.upperBound = upperBound;
    }

    public int getPowersOf() {
        return this.powersOf;
    }

    public void setPowersOf(int powersOf) {
        this.powersOf = powersOf;
    }

    @Override
    public Supplier<Delay> build() {
        return () -> Delay.exponential((java.time.Duration)java.time.Duration.ofMillis(this.lowerBound.toMilliseconds()), (java.time.Duration)java.time.Duration.ofMillis(this.upperBound.toMilliseconds()), (int)this.powersOf, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

