/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.health;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.redis.health.Pingable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisHealthCheck
extends HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(RedisHealthCheck.class);
    public static final String HEALTHY_STRING = "PONG";
    private final Pingable client;

    public RedisHealthCheck(Pingable client) {
        this.client = client;
    }

    public Pingable getClient() {
        return this.client;
    }

    protected HealthCheck.Result check() {
        try {
            return HEALTHY_STRING.equals(this.client.ping()) ? HealthCheck.Result.healthy() : HealthCheck.Result.unhealthy((String)"Could not ping Redis");
        }
        catch (RuntimeException e) {
            log.warn("Redis health check failed due to exception", (Throwable)e);
            return HealthCheck.Result.unhealthy((Throwable)e);
        }
    }
}

