/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.managed;

import io.dropwizard.lifecycle.Managed;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.api.StatefulConnection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClientManager<K, V>
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(RedisClientManager.class);
    private final AbstractRedisClient client;
    private final StatefulConnection<K, V> connection;
    private final String name;

    public RedisClientManager(AbstractRedisClient client, StatefulConnection<K, V> connection, String name) {
        this.client = Objects.requireNonNull(client);
        this.connection = Objects.requireNonNull(connection);
        this.name = Objects.requireNonNull(name);
    }

    public void start() throws Exception {
        log.info("redis={} starting", (Object)this.name);
    }

    public void stop() throws Exception {
        this.connection.close();
        this.client.shutdown();
        log.info("redis={} shut down", (Object)this.name);
    }
}

