/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.metrics;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.redis.metrics.CommandLatencyRecorderFactory;
import io.lettuce.core.metrics.CommandLatencyCollectorOptions;
import io.lettuce.core.metrics.DefaultCommandLatencyCollector;
import io.lettuce.core.metrics.DefaultCommandLatencyCollectorOptions;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.concurrent.TimeUnit;

@JsonTypeName(value="default")
public class DefaultCommandLatencyCollectorFactory
implements CommandLatencyRecorderFactory {
    @NotNull
    @JsonProperty
    private TimeUnit targetUnit = DefaultCommandLatencyCollectorOptions.DEFAULT_TARGET_UNIT;
    @NotNull
    @Size(min=1)
    @JsonProperty
    private @NotNull @Size(min=1) double[] targetPercentiles = DefaultCommandLatencyCollectorOptions.DEFAULT_TARGET_PERCENTILES;
    @JsonProperty
    private boolean resetLatenciesAfterEvent = true;
    @JsonProperty
    private boolean localDistinction = false;
    @JsonProperty
    private boolean enabled = true;

    public TimeUnit getTargetUnit() {
        return this.targetUnit;
    }

    public void setTargetUnit(TimeUnit targetUnit) {
        this.targetUnit = targetUnit;
    }

    public double[] getTargetPercentiles() {
        return this.targetPercentiles;
    }

    public void setTargetPercentiles(double[] targetPercentiles) {
        this.targetPercentiles = targetPercentiles;
    }

    public boolean isResetLatenciesAfterEvent() {
        return this.resetLatenciesAfterEvent;
    }

    public void setResetLatenciesAfterEvent(boolean resetLatenciesAfterEvent) {
        this.resetLatenciesAfterEvent = resetLatenciesAfterEvent;
    }

    public boolean isLocalDistinction() {
        return this.localDistinction;
    }

    public void setLocalDistinction(boolean localDistinction) {
        this.localDistinction = localDistinction;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public DefaultCommandLatencyCollector build(MetricRegistry metricRegistry) {
        DefaultCommandLatencyCollectorOptions.Builder builder = DefaultCommandLatencyCollectorOptions.builder().targetUnit(this.targetUnit).targetPercentiles(this.targetPercentiles).resetLatenciesAfterEvent(this.resetLatenciesAfterEvent).localDistinction(this.localDistinction);
        if (this.enabled) {
            builder.enable();
        } else {
            builder.disable();
        }
        return new DefaultCommandLatencyCollector((CommandLatencyCollectorOptions)builder.build());
    }
}

