/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.metrics.CommandLatencyId;
import io.lettuce.core.metrics.CommandLatencyRecorder;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class DropwizardCommandLatencyRecorder
implements CommandLatencyRecorder {
    static final String METRIC_COMPLETION = "lettuce.command.completion";
    static final String METRIC_FIRST_RESPONSE = "lettuce.command.firstresponse";
    private final MetricRegistry metricRegistry;
    private final boolean isEnabled;
    private final Map<CommandLatencyId, Timer> completionTimers = new ConcurrentHashMap<CommandLatencyId, Timer>();
    private final Map<CommandLatencyId, Timer> firstResponseTimers = new ConcurrentHashMap<CommandLatencyId, Timer>();

    public DropwizardCommandLatencyRecorder(MetricRegistry metricRegistry, boolean isEnabled) {
        LettuceAssert.notNull((Object)metricRegistry, (String)"MetricRegistry must not be null");
        this.metricRegistry = metricRegistry;
        this.isEnabled = isEnabled;
    }

    public void recordCommandLatency(SocketAddress local, SocketAddress remote, ProtocolKeyword protocolKeyword, long firstResponseLatency, long completionLatency) {
        if (!this.isEnabled()) {
            return;
        }
        CommandLatencyId commandLatencyId = CommandLatencyId.create((SocketAddress)local, (SocketAddress)remote, (ProtocolKeyword)protocolKeyword);
        Timer firstResponseTimer = this.firstResponseTimers.computeIfAbsent(commandLatencyId, c -> this.metricRegistry.timer(MetricRegistry.name((String)METRIC_FIRST_RESPONSE, (String[])new String[]{c.commandType().name()})));
        firstResponseTimer.update(firstResponseLatency, TimeUnit.NANOSECONDS);
        Timer completionTimer = this.completionTimers.computeIfAbsent(commandLatencyId, c -> this.metricRegistry.timer(MetricRegistry.name((String)METRIC_COMPLETION, (String[])new String[]{c.commandType().name()})));
        completionTimer.update(completionLatency, TimeUnit.NANOSECONDS);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

