/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.metrics.event.visitor;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.redis.metrics.event.visitor.EventVisitor;
import io.lettuce.core.cluster.event.ClusterTopologyChangedEvent;
import io.lettuce.core.event.connection.ConnectedEvent;
import io.lettuce.core.event.connection.ConnectionActivatedEvent;
import io.lettuce.core.event.connection.ConnectionDeactivatedEvent;
import io.lettuce.core.event.connection.DisconnectedEvent;
import io.lettuce.core.event.metrics.CommandLatencyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CommandLatencyEventVisitor
implements EventVisitor {
    private final String name;
    private final MetricRegistry metrics;
    private final Map<String, String> metricNames;

    public CommandLatencyEventVisitor(String name, MetricRegistry metrics) {
        this(name, metrics, new HashMap<String, String>());
    }

    CommandLatencyEventVisitor(String name, MetricRegistry metrics, Map<String, String> metricNames) {
        this.name = MetricRegistry.name((String)Objects.requireNonNull(name), (String[])new String[]{"event.latency"});
        this.metrics = Objects.requireNonNull(metrics);
        this.metricNames = Objects.requireNonNull(metricNames);
    }

    @Override
    public void visit(CommandLatencyEvent event) {
        event.getLatencies().forEach((commandLatencyId, commandMetrics) -> {
            String commandType = commandLatencyId.commandType().name();
            String metricName = this.metricNames.computeIfAbsent(commandType, type -> MetricRegistry.name((String)this.name, (String[])new String[]{type}));
            this.metrics.timer(metricName).update(commandMetrics.getCompletion().getMax(), commandMetrics.getTimeUnit());
        });
    }

    @Override
    public void visit(DisconnectedEvent event) {
    }

    @Override
    public void visit(ClusterTopologyChangedEvent event) {
    }

    @Override
    public void visit(ConnectedEvent event) {
    }

    @Override
    public void visit(ConnectionActivatedEvent event) {
    }

    @Override
    public void visit(ConnectionDeactivatedEvent event) {
    }
}

