/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.metrics.event.visitor;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.redis.metrics.event.visitor.EventVisitor;
import io.lettuce.core.cluster.event.ClusterTopologyChangedEvent;
import io.lettuce.core.event.connection.ConnectedEvent;
import io.lettuce.core.event.connection.ConnectionActivatedEvent;
import io.lettuce.core.event.connection.ConnectionDeactivatedEvent;
import io.lettuce.core.event.connection.DisconnectedEvent;
import io.lettuce.core.event.metrics.CommandLatencyEvent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconnectedEventVisitor
implements EventVisitor {
    private static final Logger log = LoggerFactory.getLogger(DisconnectedEventVisitor.class);
    private final String name;
    private final MetricRegistry metrics;

    public DisconnectedEventVisitor(String name, MetricRegistry metrics) {
        this.name = MetricRegistry.name((String)Objects.requireNonNull(name), (String[])new String[]{"event.disconnected"});
        this.metrics = Objects.requireNonNull(metrics);
    }

    @Override
    public void visit(CommandLatencyEvent event) {
    }

    @Override
    public void visit(DisconnectedEvent event) {
        this.metrics.counter(this.name).inc();
        log.debug("Disconnected event occurred {}", (Object)event);
    }

    @Override
    public void visit(ClusterTopologyChangedEvent event) {
    }

    @Override
    public void visit(ConnectedEvent event) {
    }

    @Override
    public void visit(ConnectionActivatedEvent event) {
    }

    @Override
    public void visit(ConnectionDeactivatedEvent event) {
    }
}

