/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.metrics.event.wrapper;

import io.dropwizard.redis.metrics.event.wrapper.VisitableClusterTopologyEventWrapper;
import io.dropwizard.redis.metrics.event.wrapper.VisitableCommandLatencyEventWrapper;
import io.dropwizard.redis.metrics.event.wrapper.VisitableConnectedEventWrapper;
import io.dropwizard.redis.metrics.event.wrapper.VisitableConnectionActivatedEventWrapper;
import io.dropwizard.redis.metrics.event.wrapper.VisitableConnectionDeactivatedEventWrapper;
import io.dropwizard.redis.metrics.event.wrapper.VisitableDisconnectedEventWrapper;
import io.dropwizard.redis.metrics.event.wrapper.VisitableEventWrapper;
import io.lettuce.core.cluster.event.ClusterTopologyChangedEvent;
import io.lettuce.core.event.Event;
import io.lettuce.core.event.connection.ConnectedEvent;
import io.lettuce.core.event.connection.ConnectionActivatedEvent;
import io.lettuce.core.event.connection.ConnectionDeactivatedEvent;
import io.lettuce.core.event.connection.DisconnectedEvent;
import io.lettuce.core.event.metrics.CommandLatencyEvent;
import java.util.Optional;

public class EventWrapperFactory {
    public static VisitableEventWrapper build(CommandLatencyEvent event) {
        return new VisitableCommandLatencyEventWrapper(event);
    }

    public static VisitableEventWrapper build(ClusterTopologyChangedEvent event) {
        return new VisitableClusterTopologyEventWrapper(event);
    }

    public static VisitableEventWrapper build(ConnectedEvent event) {
        return new VisitableConnectedEventWrapper(event);
    }

    public static VisitableEventWrapper build(ConnectionActivatedEvent event) {
        return new VisitableConnectionActivatedEventWrapper(event);
    }

    public static VisitableEventWrapper build(ConnectionDeactivatedEvent event) {
        return new VisitableConnectionDeactivatedEventWrapper(event);
    }

    public static VisitableEventWrapper build(DisconnectedEvent event) {
        return new VisitableDisconnectedEventWrapper(event);
    }

    public static Optional<VisitableEventWrapper> build(Event event) {
        if (event instanceof CommandLatencyEvent) {
            return Optional.of(EventWrapperFactory.build((CommandLatencyEvent)event));
        }
        if (event instanceof ClusterTopologyChangedEvent) {
            return Optional.of(EventWrapperFactory.build((ClusterTopologyChangedEvent)event));
        }
        if (event instanceof ConnectedEvent) {
            return Optional.of(EventWrapperFactory.build((ConnectedEvent)event));
        }
        if (event instanceof ConnectionActivatedEvent) {
            return Optional.of(EventWrapperFactory.build((ConnectionActivatedEvent)event));
        }
        if (event instanceof ConnectionDeactivatedEvent) {
            return Optional.of(EventWrapperFactory.build((ConnectionDeactivatedEvent)event));
        }
        if (event instanceof DisconnectedEvent) {
            return Optional.of(EventWrapperFactory.build((DisconnectedEvent)event));
        }
        return Optional.empty();
    }
}

