/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.ssl;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.lettuce.core.SslOptions;
import io.netty.handler.ssl.SslProvider;
import jakarta.validation.constraints.NotNull;
import java.io.File;

public class SslOptionsFactory {
    @JsonProperty
    private boolean enabled = true;
    @NotNull
    @JsonProperty
    private SslProvider sslProvider = SslOptions.DEFAULT_SSL_PROVIDER;
    @NotNull
    @JsonProperty
    private File keystore;
    @JsonProperty
    private String keystorePassword;
    @NotNull
    @JsonProperty
    private File truststore;
    @JsonProperty
    private String truststorePassword;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public void setSslProvider(SslProvider sslProvider) {
        this.sslProvider = sslProvider;
    }

    public File getKeystore() {
        return this.keystore;
    }

    public void setKeystore(File keystore) {
        this.keystore = keystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public File getTruststore() {
        return this.truststore;
    }

    public void setTruststore(File truststore) {
        this.truststore = truststore;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public SslOptions build() {
        SslOptions.Builder builder = SslOptions.builder();
        switch (this.sslProvider) {
            case JDK: {
                builder.jdkSslProvider();
                break;
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                builder.openSslProvider();
            }
        }
        if (this.keystorePassword != null) {
            builder.keystore(this.keystore, this.keystorePassword.toCharArray());
        } else {
            builder.keystore(this.keystore);
        }
        if (this.truststorePassword != null) {
            builder.truststore(this.truststore, this.truststorePassword);
        } else {
            builder.truststore(this.truststore);
        }
        return builder.build();
    }
}

