/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.timeout;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.lettuce.core.TimeoutOptions;
import java.time.Duration;

public class TimeoutOptionsFactory {
    @JsonProperty
    private boolean timeoutCommands = false;
    @JsonProperty
    private boolean applyConnectionTimeout = false;
    @JsonProperty
    private io.dropwizard.util.Duration fixedTimeout;

    public boolean isTimeoutCommands() {
        return this.timeoutCommands;
    }

    public void setTimeoutCommands(boolean timeoutCommands) {
        this.timeoutCommands = timeoutCommands;
    }

    public boolean isApplyConnectionTimeout() {
        return this.applyConnectionTimeout;
    }

    public void setApplyConnectionTimeout(boolean applyConnectionTimeout) {
        this.applyConnectionTimeout = applyConnectionTimeout;
    }

    public io.dropwizard.util.Duration getFixedTimeout() {
        return this.fixedTimeout;
    }

    public void setFixedTimeout(io.dropwizard.util.Duration fixedTimeout) {
        this.fixedTimeout = fixedTimeout;
    }

    public TimeoutOptions build() {
        TimeoutOptions.Builder builder = TimeoutOptions.builder().timeoutCommands(this.timeoutCommands);
        if (this.applyConnectionTimeout) {
            builder.connectionTimeout();
        }
        if (this.fixedTimeout != null) {
            builder.fixedTimeout(Duration.ofMillis(this.fixedTimeout.toMilliseconds()));
        }
        return builder.build();
    }
}

