/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.topology;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.Set;

public class ClusterTopologyRefreshOptionsFactory {
    @JsonProperty
    private boolean periodicRefreshEnabled = false;
    @NotNull
    @JsonProperty
    private io.dropwizard.util.Duration refreshPeriod = io.dropwizard.util.Duration.seconds((long)60L);
    @JsonProperty
    private boolean closeStaleConnections = true;
    @JsonProperty
    private boolean dynamicRefreshSources = true;
    @NotNull
    @JsonProperty
    private Set<ClusterTopologyRefreshOptions.RefreshTrigger> adaptiveRefreshTriggers = ClusterTopologyRefreshOptions.DEFAULT_ADAPTIVE_REFRESH_TRIGGERS;
    @Min(value=0L)
    @JsonProperty
    private @Min(value=0L) int refreshTriggersReconnectAttempts = 5;

    public boolean isPeriodicRefreshEnabled() {
        return this.periodicRefreshEnabled;
    }

    public void setPeriodicRefreshEnabled(boolean periodicRefreshEnabled) {
        this.periodicRefreshEnabled = periodicRefreshEnabled;
    }

    public io.dropwizard.util.Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(io.dropwizard.util.Duration refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }

    public boolean isCloseStaleConnections() {
        return this.closeStaleConnections;
    }

    public void setCloseStaleConnections(boolean closeStaleConnections) {
        this.closeStaleConnections = closeStaleConnections;
    }

    public boolean isDynamicRefreshSources() {
        return this.dynamicRefreshSources;
    }

    public void setDynamicRefreshSources(boolean dynamicRefreshSources) {
        this.dynamicRefreshSources = dynamicRefreshSources;
    }

    public Set<ClusterTopologyRefreshOptions.RefreshTrigger> getAdaptiveRefreshTriggers() {
        return this.adaptiveRefreshTriggers;
    }

    public void setAdaptiveRefreshTriggers(Set<ClusterTopologyRefreshOptions.RefreshTrigger> adaptiveRefreshTriggers) {
        this.adaptiveRefreshTriggers = adaptiveRefreshTriggers;
    }

    public int getRefreshTriggersReconnectAttempts() {
        return this.refreshTriggersReconnectAttempts;
    }

    public void setRefreshTriggersReconnectAttempts(int refreshTriggersReconnectAttempts) {
        this.refreshTriggersReconnectAttempts = refreshTriggersReconnectAttempts;
    }

    public ClusterTopologyRefreshOptions build() {
        return ClusterTopologyRefreshOptions.builder().enablePeriodicRefresh(this.periodicRefreshEnabled).refreshPeriod(Duration.ofSeconds(this.refreshPeriod.toSeconds())).closeStaleConnections(this.closeStaleConnections).dynamicRefreshSources(this.dynamicRefreshSources).enableAdaptiveRefreshTrigger(this.adaptiveRefreshTriggers.toArray(new ClusterTopologyRefreshOptions.RefreshTrigger[0])).build();
    }
}

