/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.uri;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.net.HostAndPort;
import io.dropwizard.redis.uri.RedisURIFactory;
import io.lettuce.core.RedisURI;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;

@JsonTypeName(value="redis")
public class RedisModeURIFactory
extends RedisURIFactory {
    @Valid
    @NotNull
    @JsonProperty
    private HostAndPort node;
    @JsonProperty
    private boolean ssl = false;
    @JsonProperty
    private boolean startTls = false;
    @JsonProperty
    private boolean verifyPeer = true;

    public HostAndPort getNode() {
        return this.node;
    }

    public void setNode(HostAndPort node) {
        this.node = node;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isStartTls() {
        return this.startTls;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
    }

    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.verifyPeer = verifyPeer;
    }

    @Override
    public RedisURI build() {
        RedisURI.Builder builder = RedisURI.builder().withHost(this.node.getHost()).withPort(this.node.getPort()).withSsl(this.ssl).withStartTls(this.startTls).withVerifyPeer(this.verifyPeer).withTimeout(Duration.ofSeconds(this.timeout.toSeconds()));
        if (this.clientName != null) {
            builder.withClientName(this.clientName);
        }
        if (this.username != null && this.password != null) {
            builder.withAuthentication(this.username, (CharSequence)this.password);
        } else if (this.password != null) {
            builder.withPassword(this.password);
        }
        return builder.build();
    }
}

