/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.redis.uri;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.net.HostAndPort;
import io.dropwizard.redis.uri.RedisURIFactory;
import io.lettuce.core.RedisURI;
import jakarta.validation.Valid;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;

@JsonTypeName(value="sentinel")
public class SentinelModeURIFactory
extends RedisURIFactory {
    @Valid
    @NotEmpty
    @JsonProperty
    private Set<HostAndPort> sentinels = Collections.emptySet();
    @JsonProperty
    private String sentinelMasterId;

    public Set<HostAndPort> getSentinels() {
        return this.sentinels;
    }

    public void setSentinels(Set<HostAndPort> sentinels) {
        this.sentinels = sentinels;
    }

    public String getSentinelMasterId() {
        return this.sentinelMasterId;
    }

    public void setSentinelMasterId(String sentinelMasterId) {
        this.sentinelMasterId = sentinelMasterId;
    }

    @Override
    public RedisURI build() {
        RedisURI.Builder builder = RedisURI.builder().withTimeout(Duration.ofSeconds(this.timeout.toSeconds()));
        this.sentinels.forEach(sentinel -> builder.withSentinel(sentinel.getHost(), sentinel.getPort()));
        if (this.clientName != null) {
            builder.withClientName(this.clientName);
        }
        if (this.username != null && this.password != null) {
            builder.withAuthentication(this.username, (CharSequence)this.password);
        } else if (this.password != null) {
            builder.withPassword(this.password);
        }
        if (this.sentinelMasterId != null) {
            builder.withSentinelMasterId(this.sentinelMasterId);
        }
        return builder.build();
    }
}

