/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.core.Application;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.Command;
import io.dropwizard.core.cli.ServerCommand;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.jackson.JacksonFeature;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.testing.ConfigOverride;
import io.dropwizard.testing.DropwizardTestSupport;
import jakarta.ws.rs.client.Client;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.junit.rules.ExternalResource;

public class DropwizardAppRule<C extends Configuration>
extends ExternalResource {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 5000;
    private final DropwizardTestSupport<C> testSupport;
    private final AtomicInteger recursiveCallCount = new AtomicInteger(0);
    private @Nullable Client client;

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass) {
        this(applicationClass, (String)null, new ConfigOverride[0]);
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, (String)null, configOverrides);
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigurationSourceProvider configSourceProvider, ConfigOverride ... configOverrides) {
        this((Class<Application<C>>)applicationClass, configPath, configSourceProvider, (String)null, configOverrides);
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, Optional<String> customPropertyPrefix, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, (String)customPropertyPrefix.orElse(null), configOverrides);
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, customPropertyPrefix, ServerCommand::new, configOverrides);
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigurationSourceProvider configSourceProvider, @Nullable String customPropertyPrefix, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, configSourceProvider, customPropertyPrefix, ServerCommand::new, configOverrides);
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, Optional<String> customPropertyPrefix, Function<Application<C>, Command> commandInstantiator, ConfigOverride ... configOverrides) {
        this(applicationClass, configPath, (String)customPropertyPrefix.orElse(null), commandInstantiator, configOverrides);
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, @Nullable String customPropertyPrefix, Function<Application<C>, Command> commandInstantiator, ConfigOverride ... configOverrides) {
        this(new DropwizardTestSupport(applicationClass, configPath, customPropertyPrefix, commandInstantiator, configOverrides));
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigurationSourceProvider configSourceProvider, @Nullable String customPropertyPrefix, Function<Application<C>, Command> commandInstantiator, ConfigOverride ... configOverrides) {
        this(new DropwizardTestSupport(applicationClass, configPath, configSourceProvider, customPropertyPrefix, commandInstantiator, configOverrides));
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, C configuration) {
        this(new DropwizardTestSupport(applicationClass, configuration));
    }

    public DropwizardAppRule(Class<? extends Application<C>> applicationClass, C configuration, Function<Application<C>, Command> commandInstantiator) {
        this(new DropwizardTestSupport(applicationClass, configuration, commandInstantiator));
    }

    public DropwizardAppRule(DropwizardTestSupport<C> testSupport) {
        this.testSupport = testSupport;
    }

    public DropwizardAppRule<C> addListener(final ServiceListener<C> listener) {
        this.testSupport.addListener(new DropwizardTestSupport.ServiceListener<C>(){

            public void onRun(C configuration, Environment environment, DropwizardTestSupport<C> rule) throws Exception {
                listener.onRun(configuration, environment, DropwizardAppRule.this);
            }

            public void onStop(DropwizardTestSupport<C> rule) throws Exception {
                listener.onStop(DropwizardAppRule.this);
            }
        });
        return this;
    }

    public DropwizardAppRule<C> manage(final Managed managed) {
        return this.addListener(new ServiceListener<C>(){

            @Override
            public void onRun(C configuration, Environment environment, DropwizardAppRule<C> rule) throws Exception {
                environment.lifecycle().manage(managed);
            }
        });
    }

    protected void before() throws Exception {
        if (this.recursiveCallCount.getAndIncrement() == 0) {
            this.testSupport.before();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        if (this.recursiveCallCount.decrementAndGet() == 0) {
            this.testSupport.after();
            DropwizardAppRule dropwizardAppRule = this;
            synchronized (dropwizardAppRule) {
                if (this.client != null) {
                    this.client.close();
                }
            }
        }
    }

    public C getConfiguration() {
        return (C)this.testSupport.getConfiguration();
    }

    public int getLocalPort() {
        return this.testSupport.getLocalPort();
    }

    public int getPort(int connectorIndex) {
        return this.testSupport.getPort(connectorIndex);
    }

    public int getAdminPort() {
        return this.testSupport.getAdminPort();
    }

    public Application<C> newApplication() {
        return this.testSupport.newApplication();
    }

    public <A extends Application<C>> A getApplication() {
        return (A)this.testSupport.getApplication();
    }

    public Environment getEnvironment() {
        return this.testSupport.getEnvironment();
    }

    public ObjectMapper getObjectMapper() {
        return this.testSupport.getObjectMapper();
    }

    public DropwizardTestSupport<C> getTestSupport() {
        return this.testSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client client() {
        DropwizardAppRule dropwizardAppRule = this;
        synchronized (dropwizardAppRule) {
            if (this.client == null) {
                this.client = this.clientBuilder().build();
            }
            return this.client;
        }
    }

    protected JerseyClientBuilder clientBuilder() {
        return new JerseyClientBuilder().register((Object)new JacksonFeature(this.getObjectMapper())).property("jersey.config.client.connectTimeout", (Object)1000).property("jersey.config.client.readTimeout", (Object)5000).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
    }

    public static abstract class ServiceListener<T extends Configuration> {
        public void onRun(T configuration, Environment environment, DropwizardAppRule<T> rule) throws Exception {
        }

        public void onStop(DropwizardAppRule<T> rule) throws Exception {
        }
    }
}

