/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.vavr;

import com.fasterxml.jackson.databind.Module;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.jersey.validation.Validators;
import io.dropwizard.util.Resources;
import io.dropwizard.vavr.jersey.CollectionParamFeature;
import io.dropwizard.vavr.jersey.EitherMessageBodyWriter;
import io.dropwizard.vavr.jersey.EmptyValueExceptionMapper;
import io.dropwizard.vavr.jersey.LazyParamFeature;
import io.dropwizard.vavr.jersey.OptionParamFeature;
import io.dropwizard.vavr.jersey.ValueMessageBodyWriter;
import io.dropwizard.vavr.validation.ValueValidatedValueExtractor;
import io.vavr.jackson.datatype.VavrModule;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.valueextraction.ValueExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class VavrBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private final VavrModule.Settings settings;
    private final boolean registerMessageBodyWriters;

    public VavrBundle() {
        this(false);
    }

    public VavrBundle(boolean registerMessageBodyWriters) {
        this(new VavrModule.Settings(), registerMessageBodyWriters);
    }

    public VavrBundle(VavrModule.Settings settings, boolean registerMessageBodyWriters) {
        this.settings = settings;
        this.registerMessageBodyWriters = registerMessageBodyWriters;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapper().registerModule((Module)new VavrModule(this.settings));
        bootstrap.setValidatorFactory(this.newValidatorFactory());
    }

    public void run(T configuration, Environment environment) {
        environment.jersey().register(EmptyValueExceptionMapper.class);
        environment.jersey().register(LazyParamFeature.class);
        environment.jersey().register(OptionParamFeature.class);
        environment.jersey().register(CollectionParamFeature.class);
        if (this.registerMessageBodyWriters) {
            environment.jersey().register(EitherMessageBodyWriter.class);
            environment.jersey().register(ValueMessageBodyWriter.class);
        }
    }

    protected ValidatorFactory newValidatorFactory() {
        return this.newValidatorConfiguration().buildValidatorFactory();
    }

    protected HibernateValidatorConfiguration newValidatorConfiguration() {
        InputStream vavrConstraints;
        try {
            URL resource = Resources.getResource((String)"META-INF/constraints-vavr.xml");
            vavrConstraints = resource.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validators.newConfiguration().addValueExtractor((ValueExtractor)new ValueValidatedValueExtractor())).addMapping(vavrConstraints);
    }
}

