/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.vavr.jersey;

import io.dropwizard.vavr.jersey.CollectionValueParamProvider;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.internal.process.RequestProcessingContextReference;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

public class CollectionParamBinder
extends AbstractBinder {
    protected void configure() {
        this.bind(CollectionValueParamProvider.CollectionQueryParamProvider.class).to(ValueParamProvider.class).in(Singleton.class);
        this.bind(CollectionValueParamProvider.CollectionFormParamProvider.class).to(ValueParamProvider.class).in(Singleton.class);
        this.bind(CollectionValueParamProvider.CollectionHeaderParamProvider.class).to(ValueParamProvider.class).in(Singleton.class);
        this.bind(QueryParamInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<QueryParam>>(){}).in(Singleton.class);
        this.bind(FormParamInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<FormParam>>(){}).in(Singleton.class);
        this.bind(HeaderParamInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<HeaderParam>>(){}).in(Singleton.class);
    }

    private static Provider<ContainerRequest> getContainerRequestProvider(InjectionManager injectionManager) {
        return () -> {
            RequestProcessingContextReference reference = (RequestProcessingContextReference)injectionManager.getInstance(RequestProcessingContextReference.class);
            return reference.get().request();
        };
    }

    private static class QueryParamInjectionResolver
    extends ParamInjectionResolver<QueryParam> {
        @Inject
        public QueryParamInjectionResolver(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager) {
            super((ValueParamProvider)new CollectionValueParamProvider.CollectionQueryParamProvider(mpep, injectionManager), QueryParam.class, CollectionParamBinder.getContainerRequestProvider(injectionManager));
        }
    }

    private static class FormParamInjectionResolver
    extends ParamInjectionResolver<FormParam> {
        @Inject
        public FormParamInjectionResolver(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager) {
            super((ValueParamProvider)new CollectionValueParamProvider.CollectionFormParamProvider(mpep, injectionManager), FormParam.class, CollectionParamBinder.getContainerRequestProvider(injectionManager));
        }
    }

    private static class HeaderParamInjectionResolver
    extends ParamInjectionResolver<HeaderParam> {
        @Inject
        public HeaderParamInjectionResolver(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager) {
            super((ValueParamProvider)new CollectionValueParamProvider.CollectionHeaderParamProvider(mpep, injectionManager), HeaderParam.class, CollectionParamBinder.getContainerRequestProvider(injectionManager));
        }
    }
}

