/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.vavr.jersey;

import io.dropwizard.vavr.jersey.CollectionParameterExtractor;
import io.vavr.CheckedFunction0;
import io.vavr.collection.Array;
import io.vavr.collection.List;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import io.vavr.control.Try;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;

abstract class CollectionValueParamProvider
extends AbstractValueParamProvider {
    private final InjectionManager injectionManager;

    protected CollectionValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager, Parameter.Source ... compatibleSources) {
        super(mpep, compatibleSources);
        this.injectionManager = injectionManager;
    }

    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        Option name = Option.of((Object)parameter.getSourceName());
        Option defaultValue = Option.of((Object)parameter.getDefaultValue());
        return (Function)name.filter(n -> !n.isEmpty()).flatMap(n -> this.findParamConverter(parameter.getType(), parameter.getAnnotations()).map(conv -> arg_0 -> ((ParamConverter)conv).fromString(arg_0)).flatMap(conv -> this.buildExtractor(parameter.getRawType(), (String)n, (Option<String>)defaultValue, (Function<String, Object>)conv)).map(extractor -> this.buildProvider((MultivaluedParameterExtractor<?>)extractor, !parameter.isEncoded()))).getOrNull();
    }

    private Option<MultivaluedParameterExtractor<?>> buildExtractor(Class<?> rawClass, String name, Option<String> defaultValue, Function<String, Object> conv) {
        if (rawClass.equals(Vector.class)) {
            return Option.of(new CollectionParameterExtractor<Object, Vector>(name, defaultValue, conv, Vector::ofAll));
        }
        if (rawClass.equals(List.class)) {
            return Option.of(new CollectionParameterExtractor<Object, List>(name, defaultValue, conv, List::ofAll));
        }
        if (rawClass.equals(Array.class)) {
            return Option.of(new CollectionParameterExtractor<Object, Array>(name, defaultValue, conv, Array::ofAll));
        }
        return Option.none();
    }

    protected abstract Function<ContainerRequest, ?> buildProvider(MultivaluedParameterExtractor<?> var1, boolean var2);

    private Option<ParamConverter<Object>> findParamConverter(Type type, Annotation[] annotations) {
        return List.ofAll((Iterable)ReflectionHelper.getTypeArgumentAndClass((Type)type)).headOption().flatMap(ctp -> {
            if (ctp.rawClass().equals(String.class)) {
                return Option.some((Object)new ParamConverter<Object>(){

                    public Object fromString(String value) {
                        return value;
                    }

                    public String toString(Object value) {
                        return value.toString();
                    }
                });
            }
            return List.ofAll((Iterable)Providers.getProviders((InjectionManager)this.injectionManager, ParamConverterProvider.class)).flatMap(provider -> Option.of((Object)provider.getConverter(ctp.rawClass(), ctp.type(), annotations))).headOption();
        });
    }

    static class CollectionHeaderParamProvider
    extends CollectionValueParamProvider {
        @Inject
        public CollectionHeaderParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager) {
            super(mpep, injectionManager, Parameter.Source.HEADER);
        }

        @Override
        protected Function<ContainerRequest, ?> buildProvider(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            return containerRequest -> Try.of((CheckedFunction0 & Serializable)() -> extractor.extract(containerRequest.getHeaders())).getOrElseThrow(e -> new ParamException.HeaderParamException(e.getCause(), extractor.getName(), extractor.getDefaultValueString()));
        }
    }

    static class CollectionFormParamProvider
    extends CollectionValueParamProvider {
        @Inject
        public CollectionFormParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager) {
            super(mpep, injectionManager, Parameter.Source.FORM);
        }

        @Override
        protected Function<ContainerRequest, ?> buildProvider(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            return containerRequest -> Try.of((CheckedFunction0 & Serializable)() -> {
                containerRequest.bufferEntity();
                Form form = (Form)containerRequest.readEntity(Form.class);
                return extractor.extract(form.asMap());
            }).getOrElseThrow(e -> new ParamException.FormParamException(e.getCause(), extractor.getName(), extractor.getDefaultValueString()));
        }
    }

    static class CollectionQueryParamProvider
    extends CollectionValueParamProvider {
        @Inject
        public CollectionQueryParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager) {
            super(mpep, injectionManager, Parameter.Source.QUERY);
        }

        @Override
        protected Function<ContainerRequest, ?> buildProvider(MultivaluedParameterExtractor<?> extractor, boolean decode) {
            return containerRequest -> Try.of((CheckedFunction0 & Serializable)() -> {
                MultivaluedMap parameters = containerRequest.getUriInfo().getQueryParameters(decode);
                return extractor.extract(parameters);
            }).getOrElseThrow(e -> new ParamException.QueryParamException(e.getCause(), extractor.getName(), extractor.getDefaultValueString()));
        }
    }
}

