/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.vavr.jersey;

import io.vavr.Lazy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;

@Singleton
public class LazyParamConverterProvider
implements ParamConverterProvider {
    private final InjectionManager manager;

    @Inject
    public LazyParamConverterProvider(InjectionManager manager) {
        this.manager = manager;
    }

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (Lazy.class.equals(rawType)) {
            ClassTypePair ctp;
            List ctps = ReflectionHelper.getTypeArgumentAndClass((Type)genericType);
            ClassTypePair classTypePair = ctp = ctps.size() == 1 ? (ClassTypePair)ctps.get(0) : null;
            if (ctp == null || ctp.rawClass() == String.class) {
                return new ParamConverter<T>(){

                    public T fromString(String value) {
                        return rawType.cast(Lazy.of(() -> value));
                    }

                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
            for (ParamConverterProvider provider : Providers.getProviders((InjectionManager)this.manager, ParamConverterProvider.class)) {
                final ParamConverter converter = provider.getConverter(ctp.rawClass(), ctp.type(), annotations);
                if (converter == null) continue;
                return new ParamConverter<T>(){

                    public T fromString(String value) {
                        Object convertedValue = value == null ? null : converter.fromString(value);
                        return rawType.cast(Lazy.of(() -> convertedValue));
                    }

                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
        }
        return null;
    }
}

