/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.spatial;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.spatial.ImmutableNode;
import io.druid.collections.spatial.Node;
import io.druid.collections.spatial.RTree;
import io.druid.collections.spatial.search.Bound;
import io.druid.collections.spatial.search.GutmanSearchStrategy;
import io.druid.collections.spatial.search.SearchStrategy;
import java.nio.ByteBuffer;

public class ImmutableRTree {
    private static byte VERSION = 0;
    private final int numDims;
    private final ImmutableNode root;
    private final ByteBuffer data;
    private final SearchStrategy defaultSearchStrategy = new GutmanSearchStrategy();

    public ImmutableRTree() {
        this.numDims = 0;
        this.data = ByteBuffer.wrap(new byte[0]);
        this.root = null;
    }

    public ImmutableRTree(ByteBuffer data, BitmapFactory bitmapFactory) {
        data = data.asReadOnlyBuffer();
        int initPosition = data.position();
        Preconditions.checkArgument((data.get(0) == VERSION ? 1 : 0) != 0, (Object)"Mismatching versions");
        this.numDims = data.getInt(1 + initPosition) & Short.MAX_VALUE;
        this.data = data;
        this.root = new ImmutableNode(this.numDims, initPosition, 5, data, bitmapFactory);
    }

    public static ImmutableRTree newImmutableFromMutable(RTree rTree) {
        if (rTree.getSize() == 0) {
            return new ImmutableRTree();
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[ImmutableRTree.calcNumBytes(rTree)]);
        buffer.put(VERSION);
        buffer.putInt(rTree.getNumDims());
        rTree.getRoot().storeInByteBuffer(buffer, buffer.position());
        buffer.position(0);
        return new ImmutableRTree(buffer, rTree.getBitmapFactory());
    }

    private static int calcNumBytes(RTree tree) {
        int total = 5;
        return total += ImmutableRTree.calcNodeBytes(tree.getRoot());
    }

    private static int calcNodeBytes(Node node) {
        int total = 0;
        total += node.getSizeInBytes();
        for (Node child : node.getChildren()) {
            if (node.isLeaf()) {
                total += child.getSizeInBytes();
                continue;
            }
            total += ImmutableRTree.calcNodeBytes(child);
        }
        return total;
    }

    public int size() {
        return this.data.capacity();
    }

    public ImmutableNode getRoot() {
        return this.root;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public Iterable<ImmutableBitmap> search(Bound bound) {
        return this.search(this.defaultSearchStrategy, bound);
    }

    public Iterable<ImmutableBitmap> search(SearchStrategy strategy, Bound bound) {
        if (bound.getNumDims() == this.numDims) {
            return strategy.search(this.root, bound);
        }
        return ImmutableList.of();
    }

    public byte[] toBytes() {
        ByteBuffer buf = ByteBuffer.allocate(this.data.capacity());
        buf.put(this.data.asReadOnlyBuffer());
        return buf.array();
    }

    public int compareTo(ImmutableRTree other) {
        return this.data.compareTo(other.data);
    }
}

