/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.spatial;

import com.google.common.base.Preconditions;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.MutableBitmap;
import io.druid.collections.spatial.Node;
import io.druid.collections.spatial.Point;
import io.druid.collections.spatial.RTreeUtils;
import io.druid.collections.spatial.split.LinearGutmanSplitStrategy;
import io.druid.collections.spatial.split.SplitStrategy;
import java.util.Arrays;

public class RTree {
    private final int numDims;
    private final SplitStrategy splitStrategy;
    private final BitmapFactory bitmapFactory;
    private Node root;
    private int size;

    public RTree(BitmapFactory bitmapFactory) {
        this(0, new LinearGutmanSplitStrategy(0, 0, bitmapFactory), bitmapFactory);
    }

    public RTree(int numDims, SplitStrategy splitStrategy, BitmapFactory bitmapFactory) {
        this.numDims = numDims;
        this.splitStrategy = splitStrategy;
        this.bitmapFactory = bitmapFactory;
        this.root = this.buildRoot(true);
    }

    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    public void insert(float[] coords, int entry) {
        Preconditions.checkArgument((coords.length == this.numDims ? 1 : 0) != 0);
        this.insertInner(new Point(coords, entry, this.bitmapFactory));
    }

    public void insert(float[] coords, MutableBitmap entry) {
        Preconditions.checkArgument((coords.length == this.numDims ? 1 : 0) != 0);
        this.insertInner(new Point(coords, entry));
    }

    public boolean delete(double[] coords, int entry) {
        throw new UnsupportedOperationException();
    }

    public int getSize() {
        return this.size;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public SplitStrategy getSplitStrategy() {
        return this.splitStrategy;
    }

    public Node getRoot() {
        return this.root;
    }

    private Node buildRoot(boolean isLeaf) {
        float[] initMinCoords = new float[this.numDims];
        float[] initMaxCoords = new float[this.numDims];
        Arrays.fill(initMinCoords, Float.NEGATIVE_INFINITY);
        Arrays.fill(initMaxCoords, Float.POSITIVE_INFINITY);
        return new Node(initMinCoords, initMaxCoords, isLeaf, this.bitmapFactory);
    }

    private void insertInner(Point point) {
        Node node = this.chooseLeaf(this.root, point);
        node.addChild(point);
        if (this.splitStrategy.needToSplit(node)) {
            Node[] groups = this.splitStrategy.split(node);
            this.adjustTree(groups[0], groups[1]);
        } else {
            this.adjustTree(node, null);
        }
        ++this.size;
    }

    private Node chooseLeaf(Node node, Point point) {
        node.addToBitmapIndex(point);
        if (node.isLeaf()) {
            return node;
        }
        double minCost = Double.POSITIVE_INFINITY;
        Node optimal = node.getChildren().get(0);
        for (Node child : node.getChildren()) {
            double cost = RTreeUtils.getExpansionCost(child, point);
            if (cost < minCost) {
                minCost = cost;
                optimal = child;
                continue;
            }
            if (cost != minCost || !(child.getArea() < optimal.getArea())) continue;
            optimal = child;
        }
        return this.chooseLeaf(optimal, point);
    }

    private void adjustTree(Node n, Node nn) {
        if (n == this.root) {
            if (nn != null) {
                this.root = this.buildRoot(false);
                this.root.addChild(n);
                this.root.addChild(nn);
            }
            this.root.enclose();
            return;
        }
        boolean updateParent = n.enclose();
        if (nn != null) {
            nn.enclose();
            updateParent = true;
            if (this.splitStrategy.needToSplit(n.getParent())) {
                Node[] groups = this.splitStrategy.split(n.getParent());
                this.adjustTree(groups[0], groups[1]);
            }
        }
        if (n.getParent() != null && updateParent) {
            this.adjustTree(n.getParent(), null);
        }
    }
}

