/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.spatial.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import io.druid.collections.spatial.ImmutablePoint;
import io.druid.collections.spatial.search.RectangularBound;
import java.nio.ByteBuffer;

public class PolygonBound
extends RectangularBound {
    private static final byte CACHE_TYPE_ID = 2;
    private final float[] abscissa;
    private final float[] ordinate;

    private PolygonBound(float[] abscissa, float[] ordinate, int limit) {
        super(PolygonBound.getMinCoords(abscissa, ordinate), PolygonBound.getMaxCoords(abscissa, ordinate), limit);
        this.abscissa = abscissa;
        this.ordinate = ordinate;
    }

    private static float[] getMinCoords(float[] abscissa, float[] ordinate) {
        float[] retVal = new float[]{abscissa[0], ordinate[0]};
        for (int i = 1; i < abscissa.length; ++i) {
            if (abscissa[i] < retVal[0]) {
                retVal[0] = abscissa[i];
            }
            if (!(ordinate[i] < retVal[1])) continue;
            retVal[1] = ordinate[i];
        }
        return retVal;
    }

    private static float[] getMaxCoords(float[] abscissa, float[] ordinate) {
        float[] retVal = new float[]{abscissa[0], ordinate[0]};
        for (int i = 1; i < abscissa.length; ++i) {
            if (abscissa[i] > retVal[0]) {
                retVal[0] = abscissa[i];
            }
            if (!(ordinate[i] > retVal[1])) continue;
            retVal[1] = ordinate[i];
        }
        return retVal;
    }

    @JsonCreator
    public static PolygonBound from(@JsonProperty(value="abscissa") float[] abscissa, @JsonProperty(value="ordinate") float[] ordinate, @JsonProperty(value="limit") int limit) {
        Preconditions.checkArgument((abscissa.length == ordinate.length ? 1 : 0) != 0);
        Preconditions.checkArgument((abscissa.length > 2 ? 1 : 0) != 0);
        return new PolygonBound(abscissa, ordinate, limit);
    }

    public static PolygonBound from(float[] abscissa, float[] ordinate) {
        return PolygonBound.from(abscissa, ordinate, 0);
    }

    @JsonProperty
    public float[] getOrdinate() {
        return this.ordinate;
    }

    @JsonProperty
    public float[] getAbscissa() {
        return this.abscissa;
    }

    @Override
    public boolean contains(float[] coords) {
        int polyCorners = this.abscissa.length;
        int j = polyCorners - 1;
        boolean oddNodes = false;
        int i = 0;
        while (i < polyCorners) {
            if ((this.ordinate[i] < coords[1] && this.ordinate[j] >= coords[1] || this.ordinate[j] < coords[1] && this.ordinate[i] >= coords[1]) && (this.abscissa[i] <= coords[0] || this.abscissa[j] <= coords[0]) && this.abscissa[i] + (coords[1] - this.ordinate[i]) / (this.ordinate[j] - this.ordinate[i]) * (this.abscissa[j] - this.abscissa[i]) < coords[0]) {
                oddNodes = !oddNodes;
            }
            j = i++;
        }
        return oddNodes;
    }

    @Override
    public Iterable<ImmutablePoint> filter(Iterable<ImmutablePoint> points) {
        return Iterables.filter(points, (Predicate)new Predicate<ImmutablePoint>(){

            public boolean apply(ImmutablePoint immutablePoint) {
                return PolygonBound.this.contains(immutablePoint.getCoords());
            }
        });
    }

    @Override
    public byte[] getCacheKey() {
        ByteBuffer abscissaBuffer = ByteBuffer.allocate(this.abscissa.length * 4);
        abscissaBuffer.asFloatBuffer().put(this.abscissa);
        byte[] abscissaCacheKey = abscissaBuffer.array();
        ByteBuffer ordinateBuffer = ByteBuffer.allocate(this.ordinate.length * 4);
        ordinateBuffer.asFloatBuffer().put(this.ordinate);
        byte[] ordinateCacheKey = ordinateBuffer.array();
        ByteBuffer cacheKey = ByteBuffer.allocate(1 + abscissaCacheKey.length + ordinateCacheKey.length + 4).put(abscissaCacheKey).put(ordinateCacheKey).putInt(this.getLimit()).put((byte)2);
        return cacheKey.array();
    }
}

