/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.AsyncTwitter;
import twitter4j.AsyncTwitterImpl;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.Authorization;
import twitter4j.auth.AuthorizationFactory;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;

public final class AsyncTwitterFactory
implements Serializable {
    private final Configuration conf;
    private static final long serialVersionUID = -2565686715640816219L;
    private static final AsyncTwitter SINGLETON = new AsyncTwitterImpl(ConfigurationContext.getInstance(), TwitterFactory.DEFAULT_AUTHORIZATION);

    public AsyncTwitterFactory() {
        this(ConfigurationContext.getInstance());
    }

    public AsyncTwitterFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
    }

    public AsyncTwitterFactory(String configTreePath) {
        this.conf = ConfigurationContext.getInstance((String)configTreePath);
    }

    public AsyncTwitter getInstance() {
        return this.getInstance(AuthorizationFactory.getInstance((Configuration)this.conf));
    }

    public AsyncTwitter getInstance(AccessToken accessToken) {
        String consumerKey = this.conf.getOAuthConsumerKey();
        String consumerSecret = this.conf.getOAuthConsumerSecret();
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf);
        oauth.setOAuthConsumer(consumerKey, consumerSecret);
        oauth.setOAuthAccessToken(accessToken);
        return new AsyncTwitterImpl(this.conf, (Authorization)oauth);
    }

    public AsyncTwitter getInstance(Authorization auth) {
        return new AsyncTwitterImpl(this.conf, auth);
    }

    public AsyncTwitter getInstance(Twitter twitter) {
        return new AsyncTwitterImpl(twitter.getConfiguration(), twitter.getAuthorization());
    }

    public static AsyncTwitter getSingleton() {
        return SINGLETON;
    }
}

