/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.AvroStreamInputRowParser;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.ParseSpec;
import java.util.List;
import org.apache.avro.generic.GenericRecord;

public class AvroHadoopInputRowParser
implements InputRowParser<GenericRecord> {
    private final ParseSpec parseSpec;
    private final List<String> dimensions;
    private final boolean fromPigAvroStorage;

    @JsonCreator
    public AvroHadoopInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="fromPigAvroStorage") Boolean fromPigAvroStorage) {
        this.parseSpec = parseSpec;
        this.dimensions = parseSpec.getDimensionsSpec().getDimensionNames();
        this.fromPigAvroStorage = fromPigAvroStorage == null ? false : fromPigAvroStorage;
    }

    public InputRow parse(GenericRecord record) {
        return AvroStreamInputRowParser.parseGenericRecord(record, this.parseSpec, this.dimensions, this.fromPigAvroStorage);
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @JsonProperty
    public boolean isFromPigAvroStorage() {
        return this.fromPigAvroStorage;
    }

    public InputRowParser withParseSpec(ParseSpec parseSpec) {
        return new AvroHadoopInputRowParser(parseSpec, this.fromPigAvroStorage);
    }
}

