/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.ByteBufferInputRowParser;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.avro.AvroBytesDecoder;
import io.druid.data.input.avro.GenericRecordAsMap;
import io.druid.data.input.impl.ParseSpec;
import io.druid.data.input.impl.TimestampSpec;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.joda.time.DateTime;

public class AvroStreamInputRowParser
implements ByteBufferInputRowParser {
    private final ParseSpec parseSpec;
    private final List<String> dimensions;
    private final AvroBytesDecoder avroBytesDecoder;

    @JsonCreator
    public AvroStreamInputRowParser(@JsonProperty(value="parseSpec") ParseSpec parseSpec, @JsonProperty(value="avroBytesDecoder") AvroBytesDecoder avroBytesDecoder) {
        this.parseSpec = parseSpec;
        this.dimensions = parseSpec.getDimensionsSpec().getDimensionNames();
        this.avroBytesDecoder = avroBytesDecoder;
    }

    public InputRow parse(ByteBuffer input) {
        return AvroStreamInputRowParser.parseGenericRecord(this.avroBytesDecoder.parse(input), this.parseSpec, this.dimensions, false);
    }

    protected static InputRow parseGenericRecord(GenericRecord record, ParseSpec parseSpec, List<String> dimensions, boolean fromPigAvroStorage) {
        GenericRecordAsMap genericRecordAsMap = new GenericRecordAsMap(record, fromPigAvroStorage);
        TimestampSpec timestampSpec = parseSpec.getTimestampSpec();
        DateTime dateTime = timestampSpec.extractTimestamp((Map)genericRecordAsMap);
        return new MapBasedInputRow(dateTime, dimensions, (Map)genericRecordAsMap);
    }

    @JsonProperty
    public ParseSpec getParseSpec() {
        return this.parseSpec;
    }

    @JsonProperty
    public AvroBytesDecoder getAvroBytesDecoder() {
        return this.avroBytesDecoder;
    }

    public ByteBufferInputRowParser withParseSpec(ParseSpec parseSpec) {
        return new AvroStreamInputRowParser(parseSpec, this.avroBytesDecoder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroStreamInputRowParser that = (AvroStreamInputRowParser)o;
        if (!this.parseSpec.equals((Object)that.parseSpec)) {
            return false;
        }
        if (!this.dimensions.equals(that.dimensions)) {
            return false;
        }
        return this.avroBytesDecoder.equals(that.avroBytesDecoder);
    }

    public int hashCode() {
        int result = this.parseSpec.hashCode();
        result = 31 * result + this.dimensions.hashCode();
        result = 31 * result + this.avroBytesDecoder.hashCode();
        return result;
    }
}

