/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.avro;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordAsMap
implements Map<String, Object> {
    private final GenericRecord record;
    private final boolean fromPigAvroStorage;
    private static final Function<Object, String> PIG_AVRO_STORAGE_ARRAY_TO_STRING_INCLUDING_NULL = new Function<Object, String>(){

        @Nullable
        public String apply(Object input) {
            return String.valueOf(((GenericRecord)input).get(0));
        }
    };

    public GenericRecordAsMap(GenericRecord record, boolean fromPigAvroStorage) {
        this.record = record;
        this.fromPigAvroStorage = fromPigAvroStorage;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        Object field = this.record.get(key.toString());
        if (this.fromPigAvroStorage && field instanceof GenericData.Array) {
            return Lists.transform((List)((List)field), PIG_AVRO_STORAGE_ARRAY_TO_STRING_INCLUDING_NULL);
        }
        if (field instanceof ByteBuffer) {
            return Arrays.toString(((ByteBuffer)field).array());
        }
        return field;
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

