/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata.storage.postgresql;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class PostgreSQLConnector
extends SQLMetadataConnector {
    private static final Logger log = new Logger(PostgreSQLConnector.class);
    private static final String PAYLOAD_TYPE = "BYTEA";
    private static final String SERIAL_TYPE = "BIGSERIAL";
    public static final int DEFAULT_STREAMING_RESULT_SIZE = 100;
    private final DBI dbi;
    private volatile Boolean canUpsert;

    @Inject
    public PostgreSQLConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables) {
        super(config, dbTables);
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        datasource.setDriverClassName("org.postgresql.Driver");
        this.dbi = new DBI((DataSource)datasource);
        log.info("Configured PostgreSQL as metadata storage", new Object[0]);
    }

    protected String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    protected String getSerialType() {
        return SERIAL_TYPE;
    }

    protected int getStreamingFetchSize() {
        return 100;
    }

    protected boolean canUpsert(Handle handle) throws SQLException {
        if (this.canUpsert == null) {
            DatabaseMetaData metaData = handle.getConnection().getMetaData();
            this.canUpsert = metaData.getDatabaseMajorVersion() > 9 || metaData.getDatabaseMajorVersion() == 9 && metaData.getDatabaseMinorVersion() >= 5;
        }
        return this.canUpsert;
    }

    public boolean tableExists(Handle handle, String tableName) {
        return !((Query)handle.createQuery("SELECT tablename FROM pg_catalog.pg_tables WHERE schemaname = 'public' AND tablename ILIKE :tableName").bind("tableName", tableName)).map((ResultSetMapper)StringMapper.FIRST).list().isEmpty();
    }

    public Void insertOrUpdate(final String tableName, final String keyColumn, final String valueColumn, final String key, final byte[] value) throws Exception {
        return (Void)this.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                if (PostgreSQLConnector.this.canUpsert(handle)) {
                    ((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value) ON CONFLICT (%2$s) DO UPDATE SET %3$s = EXCLUDED.%3$s", tableName, keyColumn, valueColumn)).bind("key", key)).bind("value", value)).execute();
                } else {
                    ((Update)((Update)handle.createStatement(String.format("BEGIN;\nLOCK TABLE %1$s IN SHARE ROW EXCLUSIVE MODE;\nWITH upsert AS (UPDATE %1$s SET %3$s=:value WHERE %2$s=:key RETURNING *)\n    INSERT INTO %1$s (%2$s, %3$s) SELECT :key, :value WHERE NOT EXISTS (SELECT * FROM upsert)\n;COMMIT;", tableName, keyColumn, valueColumn)).bind("key", key)).bind("value", value)).execute();
                }
                return null;
            }
        });
    }

    public DBI getDBI() {
        return this.dbi;
    }

    protected boolean connectorIsTransientException(Throwable e) {
        if (e instanceof SQLException) {
            String sqlState = ((SQLException)e).getSQLState();
            return sqlState != null && (sqlState.startsWith("08") || sqlState.startsWith("53"));
        }
        return false;
    }
}

