/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.hdfs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import com.metamx.common.CompressionUtils;
import com.metamx.common.logger.Logger;
import io.druid.segment.SegmentUtils;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.loading.DataSegmentPusherUtil;
import io.druid.storage.hdfs.HdfsDataSegmentPusherConfig;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsDataSegmentPusher
implements DataSegmentPusher {
    private static final Logger log = new Logger(HdfsDataSegmentPusher.class);
    private final HdfsDataSegmentPusherConfig config;
    private final Configuration hadoopConfig;
    private final ObjectMapper jsonMapper;

    @Inject
    public HdfsDataSegmentPusher(HdfsDataSegmentPusherConfig config, Configuration hadoopConfig, ObjectMapper jsonMapper) {
        this.config = config;
        this.hadoopConfig = hadoopConfig;
        this.jsonMapper = jsonMapper;
        log.info("Configured HDFS as deep storage", new Object[0]);
    }

    public String getPathForHadoop(String dataSource) {
        return new Path(this.config.getStorageDirectory()).toUri().toString();
    }

    public DataSegment push(File inDir, DataSegment segment) throws IOException {
        long size;
        String storageDir = DataSegmentPusherUtil.getHdfsStorageDir((DataSegment)segment);
        log.info("Copying segment[%s] to HDFS at location[%s/%s]", new Object[]{segment.getIdentifier(), this.config.getStorageDirectory(), storageDir});
        Path outFile = new Path(String.format("%s/%s/index.zip", this.config.getStorageDirectory(), storageDir));
        FileSystem fs = outFile.getFileSystem(this.hadoopConfig);
        fs.mkdirs(outFile.getParent());
        log.info("Compressing files from[%s] to [%s]", new Object[]{inDir, outFile});
        try (FSDataOutputStream out = fs.create(outFile);){
            size = CompressionUtils.zip((File)inDir, (OutputStream)out);
        }
        return this.createDescriptorFile(segment.withLoadSpec(this.makeLoadSpec(outFile)).withSize(size).withBinaryVersion(SegmentUtils.getVersionFromDir((File)inDir)), outFile.getParent(), fs);
    }

    private DataSegment createDescriptorFile(DataSegment segment, Path outDir, FileSystem fs) throws IOException {
        Path descriptorFile = new Path(outDir, "descriptor.json");
        log.info("Creating descriptor file at[%s]", new Object[]{descriptorFile});
        ByteSource.wrap((byte[])this.jsonMapper.writeValueAsBytes((Object)segment)).copyTo((ByteSink)new HdfsOutputStreamSupplier(fs, descriptorFile));
        return segment;
    }

    private ImmutableMap<String, Object> makeLoadSpec(Path outFile) {
        return ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)outFile.toString());
    }

    private static class HdfsOutputStreamSupplier
    extends ByteSink {
        private final FileSystem fs;
        private final Path descriptorFile;

        public HdfsOutputStreamSupplier(FileSystem fs, Path descriptorFile) {
            this.fs = fs;
            this.descriptorFile = descriptorFile;
        }

        public OutputStream openStream() throws IOException {
            return this.fs.create(this.descriptorFile);
        }
    }
}

