/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches;

import java.util.HashMap;
import java.util.Map;

public enum Family {
    ALPHA(1, "Alpha", 3, 3),
    QUICKSELECT(2, "QuickSelect", 3, 3),
    COMPACT(3, "Compact", 1, 3),
    UNION(4, "Union", 4, 4),
    INTERSECTION(5, "Intersection", 3, 3),
    A_NOT_B(6, "AnotB", 3, 3),
    HLL(7, "HLL", 1, 1);

    private static final Map<Integer, Family> lookupID;
    private static final Map<String, Family> lookupFamName;
    private int id_;
    private String famName_;
    private int minPreLongs_;
    private int maxPreLongs_;

    private Family(int id, String famName, int minPreLongs, int maxPreLongs) {
        this.id_ = id;
        this.famName_ = famName;
        this.minPreLongs_ = minPreLongs;
        this.maxPreLongs_ = maxPreLongs;
    }

    public int getID() {
        return this.id_;
    }

    public void checkFamilyID(int id) {
        if (id != this.id_) {
            throw new IllegalArgumentException("This Family " + this.toString() + " does not match the ID of the given Family: " + Family.idToFamily(id).toString());
        }
    }

    public String getFamName() {
        return this.famName_;
    }

    public int getMinPreLongs() {
        return this.minPreLongs_;
    }

    public int getMaxPreLongs() {
        return this.maxPreLongs_;
    }

    public String toString() {
        return this.famName_;
    }

    public static Family idToFamily(int id) {
        Family f = lookupID.get(id);
        if (f == null) {
            throw new IllegalArgumentException("Illegal Family ID: " + id);
        }
        return f;
    }

    public static Family stringToFamily(String famName) {
        Family f = lookupFamName.get(famName);
        if (f == null) {
            throw new IllegalArgumentException("Illegal Family Name: " + famName);
        }
        return f;
    }

    public static Family objectToFamily(Object obj) {
        String sname = obj.getClass().getSimpleName();
        for (Family f : Family.values()) {
            if (!sname.contains(f.toString())) continue;
            return f;
        }
        throw new IllegalArgumentException("Unknown object");
    }

    public static boolean isValidSketchID(int id) {
        int hiID = Family.COMPACT.id_;
        int loID = Family.ALPHA.id_;
        return (hiID - id | id - loID) >= 0;
    }

    public static boolean isValidSetOpID(int id) {
        int hiID = Family.A_NOT_B.id_;
        int loID = Family.UNION.id_;
        return (hiID - id | id - loID) >= 0;
    }

    static {
        lookupID = new HashMap<Integer, Family>();
        lookupFamName = new HashMap<String, Family>();
        for (Family f : Family.values()) {
            lookupID.put(f.getID(), f);
            lookupFamName.put(f.getFamName(), f);
        }
    }
}

